;-------------------------------------------------------------------------------------------
;(c) Ilya Mamontov, 2009-2012, 2025
;  FILENAME: Synth.asm
;  DESCRIPTION:  - 6 -.
;                 -       (  synth_keyscan  Synth.inc).
; 
;               _synth_procedure    512 
;-------------------------------------------------------------------------------------------

include "m8c.inc"
include "PSoCAPI.inc"
include "SDCard.inc"
include "Synth.inc"

;------------------------------------------------------------------------------
area bss(RAM,REL,CON)
BASE:	equ	Counter8_1_COUNTER_REG	; 1-  (   !)
CNUM:	equ	6						;  (-)  
;------------------------
; Variable Allocation
;------------------------
startupcnt::BLK 2	;     (       PLL).
					;  -    ().					
tickcnt::	BLK 1	;     (   )
;   
keys::		BLK 4	;    (  )
mask::		BLK 1	;   
keyOld::	BLK 1	;     (     )
keycnt::	BLK 1	; 
mode::		BLK 1	;bit 0 =     (0 -   )
					;bit 1 =   1-   UART (    )
					;bit 2 =      (  UART)
;  -
adr1::		BLK 2	;     FLASH
ptrR::		BLK	1 	;     SD (  )
ptrW::		BLK	1 	;     SD ( )
tempo:		BLK 1	;  
cntT:		BLK 1	;  
cntT2:		BLK 1	;.   (  Play)
delay:		BLK 2	;     
tmp1::		BLK 1	;1- 
tmp2:		BLK 1	;2- 
flag:		BLK 1		;    
array::		BLK CNUM*4	;      (  ) -   
icnt:		BLK 1		; -   

cntLVD::	BLK 2	;   LVD_ISR (    ) -  


area text(ROM,REL)
;------------------------------------------------------------------------------
;      A
;------------------------------------------------------------------------------
synth_load_code::
;	mov X,[adr1+0]	;  
;	mov A,[adr1+1]	;  
;	romx
	mov X,[ptrR]
	mov A,[X]
	ret
;------------------------------------------------------------------------------
;      	
;------------------------------------------------------------------------------
synth_increment::
;	inc [adr1+0]	;  1  
;	adc [adr1+1],0	;       

	inc [ptrR]		;  1 
	cmp [ptrR],buff+BUFFERSIZE*BUFFNUMBER	;    ?
	jc .skip
		mov [ptrR],buff					;,    
	.skip:
	ret
;------------------------------------------------------------------------------
;      ,  
;------------------------------------------------------------------------------
synth_init::
	;   
	mov [delay+0],0
	mov [delay+1],0
	mov [tempo],16	;     (120   )
	mov [cnt],1


	mov [ptrR],buff	; ,  
	mov [ptrW],buff
	ret
;------------------------------------------------------------------------------
;      (   0)
;------------------------------------------------------------------------------
synth_notes_off::
	mov X,(CNUM*4)	; ,   4   
	.reset:
		mov [X+array+2-4],0		;  PWM   
		mov reg[X+BASE+2-4],0	;Compare Register=0
		dec X
		dec X
		dec X
		dec X
		jnz .reset	
	.end_reset:	
	ret



;-----------------------------------------------------------------------------
;    1 -   
;
;   5"  :
;    - 126:20 (x6,3)  50   (100 )    
;   630    
;
;   5" BLDC :
;    - 10:1  8   (16 )   
;   160    
;-----------------------------------------------------------------------------
Column_0_Int::
	push A
	push X
	;   -    
	M8C_SetBank1
	xor reg[ALT_CR0],0b00001111	;LUT: c "A"  "not A"
	M8C_SetBank0
	;   -   ,   
	mov [tickcnt],0				; -

	;---------------------   ----------------------
	mov A,8				; A    (  ) 
	tst [mode],4+1		; 
	jz stage2			;         Play,      ( )
		;    
		pop X
		pop A
		reti


;-----------------------------------------------------------------------------
;    2 -    
;
;     512 
;-----------------------------------------------------------------------------
synth_procedure::
	push A
	push X

;;;;;;;;;;;;;;  ~1 (503 )  CPU  3    PLL,    ~16  (9 )  CPU Clock 12  ;;;;;;;;;;;;;;;;;;;;;
	dec [startupcnt+0]			; .     C (  -      ) 
	tst [startupcnt+1],0x80		;  (  ) 
	;************************************************************************************************
;	jmp .n3;*********       (  ) ************
	;************************************************************************************************
	jnz .n3						;    -      (.    =0xFF)
		; 511      
    	M8C_SetBank1
			and reg[OSC_CR0],~0x80	;   ILO (      ECO,      ) 
			or  reg[OSC_CR0], 0x80	;  " "    ECO
		sbb [startupcnt+1],0	; .  	
		jnc .n1					;   .  (   0) -    "0x0008"
    		or reg[OSC_CR0],0x02	; ,   .  (   ) -   CPU 12 
    		or reg[OSC_CR2],0x80	;    ...   PLLGAIN (  ) 
			jmp .n2
		.n1:
		cmp [startupcnt+1],0		;   "0x0008"
		jnz .n2
		cmp [startupcnt+0],0x08
		jnz .n2
    		; ,    "0x0008" (17.5      0) - 
    		and reg[OSC_CR0],~0x07	;	  CPU 3  ( .)
    		or  reg[OSC_CR0], 0x40	;	  PLL
		.n2:
    	M8C_SetBank0
	.n3:	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;stage0: ;------------------------   -------------------------------
	synth_keyscan		;     ( "Synth.inc")

;stage1: ;--------- -   - ------------------
	mov [icnt],0		;  - = 0
chn_loop:				;  -
	mov X,[icnt]
	;-  ,  X
	;      -- -   ( , .. .  -  0)
	cmp	[X+array+2],0	;  ?
	jnz atack			;,   
		mov A,0			; - ( )     0
		jmp writePWM
	atack:
	mov A,reg[X+BASE+2]	;  
	cmp	A,[X+array+2]	;    
	jnc skip_writePWM
		inc A			;  -    1 
	writePWM:
	mov reg[X+BASE+2],A	;   
	skip_writePWM:
	add [icnt],4		; CNUM-
	cmp [icnt],CNUM*4
	jc chn_loop			;   -  0  5


		inc [tickcnt]				;   (  0      )
		sbb [tickcnt],0				;max  = 255 (  )

	;-------------   (  - 512 )------------------
	mov A,2				; A    (   Play    ) 
	tst [mode],4+1		; 
	jnz stage2			;       Play -       ,     (  512 )
		;     (   )
		;    --       (    )
		cmp [tickcnt],100
		jnz .no_noteoff			; =100 ( ) - 0,2     1   32 
		;jc .no_noteoff				;<100 ( ) - 0,2     1   32 
			call synth_notes_off	;   100,    
		.no_noteoff:
		pop X
		pop A
		reti

stage2: ;-----------------------      ( ) -----------------------------
;      
;       -     (0 ... 160   1    -      ),
;       -    (512 )
;  A   " "     (/ 512 )
	;  240bpm: [tempo]=8
	;          120bpm: [tempo]=16 - .   2,5 / 8 ,
	;          60bpm:  [tempo]=32
	add [cntT],A	; ""
	mov A,[cntT]
	sub A,[tempo]
	jnc .tick		;   - 
			pop X	;   
			pop A
			reti
	.tick:
	;     
	mov [cntT],A	; ""

stage3: ;------------------   (  ) -----------------------
	;  	[delay] =0 (1 ), =1 (2 ),  ..   =31 (32 )
	;"3F" (  1 ) =63  (64 )
	dec [delay+0]
	sbb [delay+1],0
	jc again	;   -     
		pop X
		pop A
		reti	;  (  ) 


;------------------  ,       -------------
again:
	mov [delay+0],0	;   -     = 0
	mov [delay+1],0
	;---- ,       ------
	mov A,[ptrW]
	sub A,[ptrR]
	jnc .skip_corr	;  ptrR <= ptrW
		add A,BUFFERSIZE*BUFFNUMBER
	.skip_corr:
	cmp A,2
	jnc stage4		;  2   
		cmp A,1
		jnz .skip_check	;    ( ) -    (  ) 
			call synth_load_code	;  0   (  )
			jz synth_end			; 0,    
		.skip_check:
		pop X
		pop A
		reti	;  (     ) 


stage4: ;-----------------------------------------------------------------------------------------------------------
;    
;
; :  0xxx xxxx,  1xxx xxxx, ... ... 1xxxxxxx, ...  ...  ...  1xxxxxxx,  100xxxxx,  ...  ...  ... 0, 0
;                 .  . .                      (.7  + 5 )          
;--------------------------------------------------------------------------------------------------------------------
	
	; 1- -      
	call synth_load_code	;    A
	call synth_increment	;  [ptrR]
	cmp A,0
	jz synth_end			; 0,    

	mov [tmp1],A		; 
	asl A				;. . 
	jnc process_cmd		; .=0,     . -   

	;    
	mov [delay+0],A		;  .   2
	;     A
	call synth_load_code	;   ( .  )  A
	mov [delay+1],0		;.      0
	asl A				;. .  (2)	
	jnc .lsb			;  = 0,   -    
	rrc A				;
	mov [delay+1],A		; .  

	; -       FF,       ,         SD .
		tst [delay+1],0x60	;   6  5 -    ,         [delay+0]=0 [delay+1]=0 
		jz .skip_set0
			mov [delay+0],0	
			mov [delay+1],0	
		.skip_set0:
	
	call synth_increment	; , ..   .  
.lsb:
	rrc [delay+1]		;  2 ("")  
	rrc [delay+0]		;
	and [delay+1],0x0F	; 4    (..   = 4096 1/128   =4096*1/64  = 64 )   
	pop X
	pop A
	reti				;   -     

process_cmd: 
	;   (2- )
	call synth_load_code	;  ".- "
	call synth_increment

process_UART::	;       UART ( )
	;		;. : [tmp1] = 1- , A = 2- , bit 2  [mode] = 1   

	mov [tmp2],A	;  
	asl A			;. . 
	jnc skip_note	;  -  

	;----  . 
	cmp [tmp1],0x0E		;" "?
	jnz set_note 
	;---- " "
	mov A,[tmp2]		;  . :   -       MIDI "Set Tempo":  120 bpm   0x07, 0xA1, 0x20 (0x07A120 = 500000 ).  
	;and A,0x7F			;  7 ( , ..   )
	inc A				; ( "7"  "8",    120 bpm).
	asl A				; ( 7 ) 
	mov [tempo],A		;    (=16   120 bpm)
	jmp skip_note
	;----   . 

set_note:	;----   
	; .   (   4),  : 0,1,2...
	asl A			; 2
	and A,0x3C		;  
	;   -   		
		cmp A,(CNUM*4)
		jnc skip_note	;   CNUM   
	mov X,A				; .  

	; 
		;    Clk       (     A):
		; VC2			(A=0x16) -   ( 125 )
		; Row input 2	(A=0x1E) -   2
		; Row input 3	(A=0x1F) -   4
		; Broadcast net	(A=0x12) -   8
		; VC3			(A=0x11) -   16
		;:
		;	   7  ,    6,      2 
		;	   0  ,    1 (  )
	mov A,[tmp1]		;   -  A 
	and A,0x70			;  
	asr A
	asr A
	asr A
	asr A				;3 . -   0...7 
		; 7  -   ,    (   )
		mov [flag],1		;  7-  
		cmp A,7				;7 : C=0,				0...6 : C=1
		sbb [flag],0		;7 : [flag]=1,		0...6 : [flag]=0
	index o_table		;    A
	M8C_SetBank1
	mov reg[X+BASE+1],A	;   
	M8C_SetBank0

	;  (..       )

	mov A,[tmp1]		;   
	and A,0x0F			; . 4  (  1...12)
	index n_table		;    
	dec [flag]			;  7- :
	jc load_period		;	  0...6 ,     
		rrc A			;	    2  (   C=0)
load_period:	
	dec A				;     1!
	mov reg[X+BASE+1],A	;  
	mov [X+array+0],A	; 

	;  (     )
	; - 1/2  

	add A,0				; ,   -  
.r:	rrc A				;   2 
	add [tmp2],0x10		; 7  tmp2 - = 1,    8 ,   16
	jnc .r				; 1...8 ,  A    1/2   1/256   (.. 0)
	;! ,   ,      6  7  (   < 8 )  		
	mov [X+array+2],A	;     
	mov reg[X+BASE+2],0	;    0 

skip_note:
	tst [mode],4		;   
	jnz exit			;      

	jmp again			;     ,         (0)



synth_end::
	;   ,     (     - !)
	mov [ptrR],[ptrW]		; ,      
	;call synth_notes_off	;    (  )
	pop X
	pop A
	reti

exit:
	and [mode],~4	;  
	pop X
	pop A
	reti

.LITERAL
;----------------      ( ) -------------------
; 		-  1    2    3    4    5    6    7    8    9    10   11   12  -  -  -
; 	-  C    C#   D    D#   E    F    F#   G    G#   A    A#   B   -  -  - 
;n_table:	DB 0, 246, 232, 219, 207, 195, 184, 174, 164, 155, 146, 138, 130, 0, 0, 0    ;A5:  24  :12 :8 :2 :146 = 856 ( 1 - "..",   -50 )
n_table:	DB 0, 239, 226, 213, 201, 190, 179, 169, 160, 151, 142, 134, 127, 0, 0, 0    ;A5:  24  :12 :8 :2 :142 = 880 ( 2 -  ,   )
;----------------      (   -----------------------
; 	  0            1            2           3            4            5            6            7 
;  VC2	:16          :16          :16          :8           :4           :2           :1           :1
;               VC3          VC3          VC3       Broadcast   Row input 3   Row input 2     VC2          VC2    =24  :12 :8 = 250 
o_table:	DB 0x11,        0x11,        0x11,        0x12,        0x1F,        0x1E,        0x16,         0x16






;        ("")
	;--------------------------------------------------------------------------------------------------------------------------
	; : 0xxx xxxx,   1xxx xxxx,  ...  ...  1xxxxxxx, ...    ...  1xxxxxxx,  100xxxxx,  ...  ...  ... 0, 0
	;                .   . .                         (.7  + 5 )          
	;                                                 1/64...2                    2...64  ( 120bpm)
	;
	;:    0...7 (3 - A220, 4 - A440 ("A4"), 5 - A880,)
	;:      1...C -     
	;            "":
	;           0 -   () ( )
	;           0x*D - 
	;           0x0E -   3...127 (7  .: =3 - 240bpm ... =7 - 120bpm ... =15 - 60bpm ...  =127 - 7,5bpm)

	;           0x1E -   N  ( )
	;           0x2E -      N ( )
	;           0x*F - NOP ( )
	;: 0 -  ... 7 - 
	;: 0...15 (  0...5)
	;:   1/128 ,   1
	;          (..   0 - 1/128,    1 - 1/64,    3 - 1/32,    7 - 1/16,    F - 1/8,   1F - 1/4,   3F - 1/2,   7F -  (2 c))
	;          (= 80 - 1/128,   81 - 1/64,   83 - 1/32,   87 - 1/16,   8F - 1/8,   9F - 1/4,   BF - 1/2,   FF -  (2 c))
	;---------------------------------------------------------------------------------------------------------------------------


;------------------------------------------------------------------------------ 
track0::
include "track0.inc"
;------------------------------------------------------------------------------ 
track1::
include "track1.inc"
;------------------------------------------------------------------------------ 
track2::
include "track2.inc"
;------------------------------------------------------------------------------ 
track3::
include "track3.inc"
;------------------------------------------------------------------------------ 
track4::
include "track4.inc"
;------------------------------------------------------------------------------ 
track5::
include "track5.inc"
;------------------------------------------------------------------------------ 
track6::
include "track6.inc"
;------------------------------------------------------------------------------ 
track7::
include "track7.inc"
;------------------------------------------------------------------------------ 
track8::
include "track8.inc"
;------------------------------------------------------------------------------ 
track9::
include "track9.inc"

;------------------------------------------------------------------------------ 
.ENDLITERAL	